/*
 * Interval.java
 *
 * Created on 11. Dezember 2006, 23:53
 *
 * Written by:
 * Frank Bicking: 504628
 * Martin Schrder: 502301
 *
 * Group: Bort
 */

package constraintprop;

import java.util.Vector;
import java.util.Enumeration;

/**
 * A class for handling variably sized intervals of type double.
 * Currently only stub.
 *
 * @author Martin Schrder, 502301
 * @author Frank Bicking, 504628
 */
public class Interval {
    /**
     * This Vector stores pairs of Doubles as left and right delimeters of 
     * a given interval. Should be initialized with
     * <Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY> and then amended
     * with all further constraining intervals
     */
    private Vector<Double> intervals;
    /**
     * Used to store the cut of all intervals, so that we don't need to
     * recompute it over and over again. When the intervals don't fit, this
     * is set so that cut_left > cut_right.
     */
    private double cut_left;
    private double cut_right;
    
    /** Creates a new instance of Interval */
    public Interval() {
        //Initializing the starting interval
        intervals = new Vector<Double>(2);
        intervals.add(new Double(Double.NEGATIVE_INFINITY));
        intervals.add(new Double(Double.POSITIVE_INFINITY));
        cut_left = Double.NEGATIVE_INFINITY;
        cut_right = Double.POSITIVE_INFINITY;
    }
    
    /**
     * Tells us if the cut set of all stored intervals is consistent insofar as
     * that there's only 1 result.
     */
    public boolean cutIsSane() {
        return cut_left <= cut_right;
    }
    
    /**
     * Computes a cut between the old interval and a new interval.
     * This will always result in one new interval, which is then stored as
     * the new cut_left and cut_right.
     */
    private void cut(double i_left, double i_right) {
        if (cutIsSane()) {
            if (cut_left < i_left) cut_left = i_left;
            if (cut_right > i_right) cut_right = i_right;
        }
    }
    
    public void addInterval(double i_left, double i_right) {
        //Checking if the given interval is sane and if not, we correct it
        if (i_left > i_right) {
            double tmp = i_right;
            i_right = i_left;
            i_left = tmp;
        }
        //Adding the sanitized interval limits
        intervals.add(new Double(i_left));
        intervals.add(new Double(i_right));
        //And recomputing the cut
        this.cut(i_left, i_right);
    }
    
    public double getCutLeft() {
        return cut_left;
    }
    
    public double getCutRight() {
        return cut_right;
    }
    
    public String toStringCut() {
        if (cutIsSane()) {
            return "<" + Double.toString(cut_left) +
                   " ; " + Double.toString(cut_right) + ">";
        } else {
            return "Cut is not sane.";
        }
    }
    
    public String toString() {
        Double tmp;
        StringBuffer strBuf = new StringBuffer();
        Enumeration<Double> iter = intervals.elements();
        while (iter.hasMoreElements()) {
            tmp = iter.nextElement();
            strBuf.append("<" + tmp.toString() + " ; ");
            tmp = iter.nextElement();
            strBuf.append(tmp.toString() + "> ");
        }
        return strBuf.toString();
    }
    
}
